﻿using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI;
using System.Collections.Generic;
using System.Linq;
using System.Windows;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class BloodUnitProductCodeViewModel : ViewModelBase
    {
        #region Properties
        /// <summary>
        /// Fires when user clicks the OK button
        /// </summary>
        public DelegateCommand OKCommand { get; private set; }
        /// <summary>
        /// Fired when user clicks the Cancel button
        /// </summary>
        public DelegateCommand CancelCommand { get; private set; }

        private string headingCaption;
        /// <summary>
        /// HeadingCaption
        /// </summary>
        public string HeadingCaption
        {
            get
            {
                return headingCaption;
            }
            set
            {
                headingCaption = value;
                RaisePropertyChanged(() => HeadingCaption);
            }
        }

        private IList<BloodUnitModel> bloodUnitList;
        /// <summary>
        /// ProductCodeList
        /// </summary>
        public IList<BloodUnitModel> BloodUnitList
        {
            get
            {
                return bloodUnitList;
            }
            set
            {
                bloodUnitList = value;
                RaisePropertyChanged(() => BloodUnitList);
            }
        }

        private BloodUnitModel selectedBloodUnit;
        /// <summary>
        /// SelectedBloodUnit
        /// </summary>
        public BloodUnitModel SelectedBloodUnit
        {
            get
            {
                return selectedBloodUnit;
            }
            set
            {
                selectedBloodUnit = value;
                RaisePropertyChanged(() => SelectedBloodUnit);
            }
        }
        #endregion

        /// <summary>
        /// Constructor
        /// </summary>
        public BloodUnitProductCodeViewModel()
        {
            CanMaximize = false;
            CanMinimize = false;

            OKCommand = new DelegateCommand(OnOKCommand);
            CancelCommand = new DelegateCommand(OnCancelCommand);

            //ProductCodeList = new List<ProductCode>();
            //ProductCodeList.Add(new ProductCode("04900V00", "Washed RED BLOOD CELLS"));
            //ProductCodeList.Add(new ProductCode("18401V00", "PLASMA"));
            //RaisePropertyChanged(() => ProductCodeList);
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="bloodUnitId"></param>
        /// <param name="bloodUnitModel"></param>
        /// <param name="vbecsBaseForm"></param>
        public BloodUnitProductCodeViewModel(string bloodUnitId, BloodUnitModel bloodUnitModel, VbecsBaseForm vbecsBaseForm)
            : this(bloodUnitId, null, bloodUnitModel, vbecsBaseForm)
        {
        }

        /// <summary>
        /// Constructor with specimenUid
        /// </summary>
        /// <param name="bloodUnitId"></param>
        /// <param name="specimenUid"></param>
        /// <param name="bloodUnitModel"></param>
        /// <param name="vbecsBaseForm"></param>
        public BloodUnitProductCodeViewModel(string bloodUnitId, string specimenUid, BloodUnitModel bloodUnitModel, VbecsBaseForm vbecsBaseForm)
            : this()
        {
            SetVbecsBaseForm(vbecsBaseForm, true);
            HeadingCaption = "Please select a Product Code for unit: " + bloodUnitId;

            // Get the appropriate product codes from the db
            // Defect 282082
            BloodUnitList = PendingBloodUnitTest.GetValidBloodUnits(LogonUser.LogonUserDivisionCode.Trim(), bloodUnitId, specimenUid).ToList();

            if (bloodUnitModel == null)
            {
                FormText = "Add Product Code";
            }
            else
            {
                FormText = "Edit Product Code";
                SelectedBloodUnit = BloodUnitList.FirstOrDefault(x => x.BloodUnitGuid == bloodUnitModel.BloodUnitGuid);
            }
        }

        #region Events
        /// <summary>
        /// Fires when user clicks OK button
        /// </summary>
        private void OnOKCommand()
        {
            if (SelectedBloodUnit == null)
            {
                MessageBox.Show("Please select a product code", "Missing Data");
                return;
            }
            //ValidateAndRaisePropertyChanged(() => SelectedCannedComment, selectedCannedComment);

            //if (!HasErrors)
            //{
            //    if (!string.IsNullOrEmpty(SelectedCannedComment.Comment))
            //    {
            //        if (AllowFreeText)
            //        {
            //            SavedCannedComment = new CannedComment(SelectedCannedComment.CannedCommentId, SelectedCannedComment.Comment, AllowFreeText, FreeText);
            //        }
            //        else
            //        {
            //            SavedCannedComment = new CannedComment(SelectedCannedComment.CannedCommentId, SelectedCannedComment.Comment, false, null);
            //        }
            //    }

                VbecsBaseForm.DialogResult = System.Windows.Forms.DialogResult.OK;
                VbecsBaseForm.Close();
            //}
        }

        /// <summary>
        /// Fires when user clicks Cancel button
        /// </summary>
        private void OnCancelCommand()
        {
            VbecsBaseForm.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            VbecsBaseForm.Close();
        }
        #endregion

    }
}
